/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import pse.assessment.AssessmentCompoundObservable;
import pse.assessment.AssessmentObject;
import pse.assessment.AssessmentSmv;
import pse.assessment.ConsistencyChecker;
import pse.assessment.PantherAssessment;
import pse.assessment.PantherTask;
import pse.assessment.ProficiencyAssignment;
import pse.assessment.SmvComparator;
import pse.util.general.LookupList;
import pse.util.general.SimplePair;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;
import skeletonapplet.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PantherForm
extends AssessmentObject {
    protected List<String> taskVdsIdents = new ArrayList<String>();
    protected List<PantherTask> tasks = new ArrayList<PantherTask>();
    protected LookupList<String, AssessmentSmv> smvs = new LookupList();
    protected PantherAssessment assessment;
    protected AssessmentSmv defaultSmv;
    protected String description;
    protected String intro;
    protected String title;
    protected String vdsIdent;
    protected String minimumPtVersion = null;

    @Override
    public String getElementName() {
        return "assessmentform";
    }

    @Override
    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
        for (String object : this.taskVdsIdents) {
            if (consistencyChecker.getTask(object) != null) continue;
            consistencyChecker.missingTask(this, object);
        }
        for (AssessmentSmv assessmentSmv : this.smvs) {
            assessmentSmv.checkForConsistency(consistencyChecker);
        }
    }

    @Override
    public boolean hasAttributes() {
        return true;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.nonEmptyString(this.title) || this.nonEmptyString(this.description) || this.nonEmptyString(this.intro) || this.taskVdsIdents.size() > 0 || this.tasks.size() > 0 || this.smvs.size() > 0;
    }

    public PantherTask getDefaultTask() {
        return this.tasks.isEmpty() ? null : this.tasks.get(0);
    }

    public List<PantherTask> getTasks() {
        return this.tasks;
    }

    public void addTask(PantherTask pantherTask) {
        pantherTask.setPantherForm(this);
        this.tasks.add(pantherTask);
        this.makeConnections(pantherTask);
    }

    public List<String> getTaskVdsIdents() {
        return this.taskVdsIdents;
    }

    public AssessmentSmv getSmvByVdsIdent(String string) {
        return this.smvs.get(string);
    }

    public List<AssessmentSmv> getSmvs() {
        return this.smvs.getList();
    }

    public void addSmv(AssessmentSmv assessmentSmv) {
        this.smvs.add(assessmentSmv.getVdsIdent(), assessmentSmv);
        if (assessmentSmv.isDefault()) {
            this.setDefaultSmv(assessmentSmv);
        }
    }

    public PantherAssessment getAssessment() {
        return this.assessment;
    }

    public void setAssessment(PantherAssessment pantherAssessment) {
        this.assessment = pantherAssessment;
    }

    public AssessmentSmv getDefaultSmv() {
        return this.defaultSmv;
    }

    public void setDefaultSmv(AssessmentSmv assessmentSmv) {
        if (this.defaultSmv != null) {
            this.defaultSmv.setIsDefault(false);
        }
        this.defaultSmv = assessmentSmv;
        this.defaultSmv.setIsDefault(true);
        if (!this.smvs.contains(assessmentSmv)) {
            this.addSmv(assessmentSmv);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getIntro() {
        return this.intro;
    }

    public void setIntro(String string) {
        this.intro = string;
    }

    public String getMinimumPtVersion() {
        return this.minimumPtVersion;
    }

    public void setMinimumPtVersion(String string) {
        this.minimumPtVersion = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getVdsIdent() {
        return this.vdsIdent;
    }

    public void setVdsIdent(String string) {
        this.vdsIdent = string;
    }

    @Override
    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("vds-ident", this.vdsIdent);
    }

    @Override
    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        xmlWriter.addOptionalTextElement("title", this.title);
        xmlWriter.addOptionalTextElement("description", this.description);
        xmlWriter.addOptionalTextElement("intro", this.intro);
        for (AssessmentSmv object : this.smvs) {
            this.addChild(xmlWriter, object);
        }
        xmlWriter.openElement("tasks");
        for (String string : this.taskVdsIdents) {
            xmlWriter.addElement("task-ref", "vds-ident", string);
        }
        xmlWriter.closeElement();
    }

    protected void makeConnections(PantherTask pantherTask) {
        for (AssessmentSmv assessmentSmv : this.smvs) {
            assessmentSmv.makeConnections(pantherTask);
        }
    }

    @Override
    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.vdsIdent = XmlUtils.getAttribute(node, "vds-ident");
    }

    @Override
    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        this.title = XmlUtils.getChildText(node, "title");
        this.description = XmlUtils.getChildText(node, "description");
        this.intro = XmlUtils.getChildText(node, "intro");
        List<Node> list = XmlUtils.getNodeChildren(node, "smv");
        for (Node object : list) {
            this.addSmv((AssessmentSmv)this.readChildFromChildNode(object, new AssessmentSmv()));
        }
        Node node2 = XmlUtils.getChild(node, "tasks");
        list = XmlUtils.getNodeChildren(node2, "task-ref");
        for (Node node3 : list) {
            this.taskVdsIdents.add(XmlUtils.getAttribute(node3, "vds-ident"));
        }
    }

    public static PantherForm createDefaultForm(PantherTask pantherTask) {
        int n = 0;
        PantherAssessment pantherAssessment = new PantherAssessment();
        pantherAssessment.setTitle("Temporary Assessment");
        pantherAssessment.setVdsIdent(PantherForm.createTempIdent(n++));
        PantherForm pantherForm = new PantherForm();
        pantherForm.setTitle("Temporary Form");
        pantherForm.setVdsIdent(PantherForm.createTempIdent(n++));
        int n2 = 0;
        AssessmentSmv assessmentSmv = new AssessmentSmv();
        assessmentSmv.setIsDefault(true);
        assessmentSmv.setVdsIdent(PantherForm.createTempIdent(n++));
        pantherForm.setDefaultSmv(assessmentSmv);
        pantherTask.setVdsIdent(PantherForm.createTempIdent(n++));
        for (AssessmentCompoundObservable assessmentCompoundObservable : pantherTask.getTopLevelObservables()) {
            assessmentCompoundObservable.setVdsIdent(PantherForm.createTempIdent(n++));
            n2 += assessmentCompoundObservable.getMaximumPoints();
            SimplePair<String, String> simplePair = new SimplePair<String, String>(pantherTask.getVdsIdent(), assessmentCompoundObservable.getVdsIdent());
            assessmentSmv.addCompoundObservable(assessmentCompoundObservable);
            assessmentSmv.addObservableReference(simplePair);
        }
        int n3 = -1;
        int n4 = n2 / 4;
        int n5 = n2 / 2;
        int n6 = 3 * n2 / 4;
        int n7 = n2;
        PantherForm.addProficiency(assessmentSmv, PantherForm.createTempIdent(n++), n3, n4);
        PantherForm.addProficiency(assessmentSmv, PantherForm.createTempIdent(n++), n4, n5);
        PantherForm.addProficiency(assessmentSmv, PantherForm.createTempIdent(n++), n5, n6);
        PantherForm.addProficiency(assessmentSmv, PantherForm.createTempIdent(n++), n6, n7);
        pantherAssessment.addForm(pantherForm);
        pantherForm.setAssessment(pantherAssessment);
        pantherForm.addTask(pantherTask);
        pantherTask.setPantherForm(pantherForm);
        return pantherForm;
    }

    protected static void addProficiency(AssessmentSmv assessmentSmv, String string, int n, int n2) {
        ProficiencyAssignment proficiencyAssignment = new ProficiencyAssignment();
        proficiencyAssignment.setVdsIdent(string);
        SmvComparator.GreaterThan greaterThan = new SmvComparator.GreaterThan();
        greaterThan.setValue(n);
        SmvComparator.LessThanOrEquals lessThanOrEquals = new SmvComparator.LessThanOrEquals();
        lessThanOrEquals.setValue(n2);
        proficiencyAssignment.addSmvComparator(greaterThan);
        proficiencyAssignment.addSmvComparator(lessThanOrEquals);
        assessmentSmv.addProficiencyAssignment(proficiencyAssignment);
    }

    protected static String createTempIdent(int n) {
        return "temp-ident-" + Utilities.padBefore(String.valueOf(n), "0", 3);
    }
}

